//###################################################################
// Joystick.cpp : Joystick control function
//
// S_JoyButtonDown()	: JoyStick button pressed related function
// S_JoyButtonUp()		: JoyStick button released related function
// S_JoyMove()			: JoyStick moving handle function
//###################################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "mmsystem.h"
#include "cruisedlg.h"
#include "Comm.h"
#include "GlobalVar.h"

#define JLeft		1
#define JHCenter	0
#define JRight 		2

#define JUp			1
#define JVCenter	0
#define JDown		2

//###################################################################
// S_JoyButtonDown()
//
// JoyStick button pressed related function
//####################################################################
LONG CControlDlg::S_JoyButtonDown(UINT wParam,LONG lParam)
{

if( wParam & JOY_BUTTON1CHG )
	{
	if(G_CruiseDlgOn==1)
		if(JoyButtonTimes==0)
			{
			::PostMessage(G_CruiseDlg->m_hWnd,WM_COMMAND,IDC_CRUISE_RECORD_START,BN_CLICKED);
			JoyButtonTimes=1;
			}
		else
			{
			::PostMessage(G_CruiseDlg->m_hWnd,WM_COMMAND,IDC_CRUISE_RECORD_STOP,BN_CLICKED);
			JoyButtonTimes=0;
			}
	sndPlaySound(lpSound2, SND_LOOP | SND_ASYNC | SND_MEMORY);
	}
else
	sndPlaySound(lpSound1, SND_ASYNC | SND_MEMORY);

return(0);
}


//####################################################################
// S_JoyButtonUp()
//
// JoyStick button released related function
//####################################################################
LONG CControlDlg::S_JoyButtonUp(UINT wParam,LONG lParam)
{

sndPlaySound(NULL,SND_ASYNC);

return(0);
}


//####################################################################
// S_JoyMove()
//
// JoyStick moving handle function
//####################################################################
LONG CControlDlg::S_JoyMove(UINT wParam,LONG lParam)
{
UINT		fwButtons;
WORD		xPos,yPos;
JOYINFO		joyInfo;

fwButtons = wParam; 
xPos = LOWORD(lParam); 
yPos = HIWORD(lParam); 

//------------------------------------------------------------------
CSliderCtrl*	pSlider_PanSpeed;
CSliderCtrl*	pSlider_TiltSpeed;
pSlider_PanSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_PAN_SPEED);
pSlider_TiltSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_TILT_SPEED);

m_nPanSpeed=pSlider_PanSpeed->GetPos();
m_nTiltSpeed=pSlider_TiltSpeed->GetPos();
//------------------------------------------------------------------

//--	0x2AAA=0xFFFF/6				0x5554=0xFFFF*(2/6)		
//--	0xAAAB=0xFFFF-0x2AAA*2		0xD555=0xFFFF-0x2AAA	
//------------- left or right ? -----------------------------------
if ( (xPos< 0x5554)||(xPos> 0xaaab) )	//-- 3fff,bfff
	{
	if (xPos< 0x5554)					//-- Left
		{
		if ( JoyHStatus!=JLeft )
			{
			//-----------------------------------------------------
			if ( DomeEnable==1)
				{
				if (ManualFlag==0)
					{
					CComm::S_COM_Manual();
					ManualFlag=1;
					}
				//--- Judge fast left or slow left ----
				Sleep(200);
				joyGetPos(JOYSTICKID1,&joyInfo);
				if(joyInfo.wXpos<0x2aaa)
					CComm::S_COM_Left(m_nPanSpeed);
				else
					CComm::S_COM_Left(1);
				JoyHStatus=JLeft;
				//--------------------------------------
				}
			//------------------------------------------------------
			}
		}
	else				//-- Right
		{
		if (JoyHStatus!=JRight)
			{
			//------------------------------------------------------
			if ( DomeEnable==1)
				{
				if (ManualFlag==0)
					{
					CComm::S_COM_Manual();
					ManualFlag=1;
					}
				//--- judge right motion fast or slow ---
				Sleep(200);
				joyGetPos(JOYSTICKID1,&joyInfo);
				if(joyInfo.wXpos>0xd555)
					CComm::S_COM_Right(m_nPanSpeed);
				else
					CComm::S_COM_Right(1);
				JoyHStatus=JRight;
				//---------------------------------------
				}
			//------------------------------------------------------
			}
		}
	}
else					//-- Center
	{
	if ( JoyHStatus!=JHCenter )
		{
		//Sleep(1);		//--- For firmware bug ----
		CComm::S_COM_PanStop();
		JoyHStatus=JHCenter;
		}
	}
//-------------- Up or Down ? --------------------------------------
if ( (yPos< 0x5554)||(yPos> 0xaaab) )
	{
	if (yPos< 0x5554)	//-- Up
		{
		if (JoyVStatus!=JUp)
			{
			//----------------------------------------
			if ( DomeEnable==1)
				{
				if (ManualFlag==0)
					{
					CComm::S_COM_Manual();
					ManualFlag=1;
					}
				//-----------------------
				Sleep(200);
				joyGetPos(JOYSTICKID1,&joyInfo);
				if (joyInfo.wYpos<0x2aaa)
					CComm::S_COM_Up(m_nTiltSpeed);
				else
					CComm::S_COM_Up(1);
				JoyVStatus=JUp;
				//------------------------
				}
			//----------------------------------------
			}
		}
	else				//-- Down
		{
		if (JoyVStatus!=JDown)
			{
			//-----------------------------------------------------
			if ( DomeEnable==1)
				{
				if (ManualFlag==0)
					{
					CComm::S_COM_Manual();
					ManualFlag=1;
					}
				//------------------------
				Sleep(200);
				joyGetPos(JOYSTICKID1,&joyInfo);
				if (joyInfo.wYpos>0xd555)
					CComm::S_COM_Down(m_nTiltSpeed);
				else
					CComm::S_COM_Down(1);
				JoyVStatus=JDown;
				//------------------------
				}
			//-----------------------------------------------------
			}
		}
	}
else					//-- Center
	{
	if ( JoyVStatus!=JVCenter )
		{
		//Sleep(1);		//--- For firmware bug ----
		CComm::S_COM_TiltStop();
		JoyVStatus=JVCenter;
		}
	}


return(0);

}
